\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{HiSST}[15/03/2018 Class for the International Conference on High-Speed Vehicle Science and Technology (HiSST) Manuscripts - by Jeroen Van den Eynde]
%-------------------------------------------
%              __ ___ ______________
%             / // (_) __/ __/_  __/
%            / _  / /\ \_\ \  / /   
%           /_//_/_/___/___/ /_/    
%
%       International Conference on 
%   High-Speed Vehicle Science & Technology
%-------------------------------------------
%       MANUSCRIPT TEMPLATE FOR LATEX
%-------------------------------------------   
%      Created by Jeroen Van den Eynde
% 

% ------------------------------------------------------------------------------
\LoadClass[10pt,twoside]{article}

% Document needs to be compiled with LuaLaTeX (or XeTeX) to use system fonts.
\RequirePackage{ifluatex,ifxetex}
\ifluatex
% Great! Do nothing.
\else
\ifxetex
% Also great. Do nothing.
\else
\ClassError{HiSST}{Documents written with the HiSST class need to be compiled using LuaLaTeX or XeTex to make use of system fonts, i.e. Tahoma and Arial.}{Please use LuaLaTeX or XeTeX to compile this document.}
\fi
\fi

% ------------------------------------------------------------------------------
% DOCUMENT PROPERTIES
% ------------------------------------------------------------------------------
% Short Title
\newcommand\shorttitle[1]{\renewcommand\@shorttitle{#1}}
\newcommand\@shorttitle{}

% Short Title
\newcommand\shortauthor[1]{\renewcommand\@shortauthor{#1}}
\newcommand\@shortauthor{\@docauthor}

% Manuscript ID
\newcommand\manuscriptid[1]{\renewcommand\@manuscriptid{#1}}
\newcommand\@manuscriptid{HiSST 2018-xxxx}

% ------------------------------------------------------------------------------
% PAGE LAYOUT AND SETUP
% ------------------------------------------------------------------------------
% Set the dimensions and margins of the page
\RequirePackage[a4paper,%
		top=4.0cm, bottom=3.0cm,%
		left=2.54cm, right=2.54cm,%
		headsep=0.2cm,headheight=62pt,%
	    footskip=1.5cm]{geometry}

% Set doctitle and short title		
\def\title#1{\gdef\@title{#1}\gdef\doctitle{#1}\shorttitle{#1}}

% Set alias for author to be used in footer
\renewcommand{\author}[1]{\gdef\@author{#1}\gdef\docauthor{#1}}

% Set styles for section and subsections		
\RequirePackage{titlesec}% Change style of sections
\titleformat{\section}{\fontsize{11pt}{13pt}\selectfont\bfseries}{\thesection.}{0.3cm}{}
\titleformat{\subsection}{\bfseries}{\thesubsection.}{0.3cm}{}
\titleformat{\subsubsection}{\bfseries\itshape}{\thesubsubsection.}{0.3cm}{}

\titlespacing*{\section}{0pt}{12pt plus 1pt minus 1pt}{0pt plus 1pt}
\titlespacing*{\subsection}{0pt}{6pt plus 1pt minus 1pt}{0pt plus 1pt}
\titlespacing*{\subsubsection}{0pt}{6pt plus 1pt minus 1pt}{0pt plus 1pt}
\titlespacing*{\paragraph}{0pt}{0pt plus 1pt minus 1pt}{6pt plus 1pt}

\RequirePackage[parfill]{parskip}% Non-zero paragraph

% Set caption styles
\RequirePackage{caption}% Modify captions
\captionsetup{labelfont=bf,labelsep=period,aboveskip=6pt,belowskip=6pt}
\renewcommand{\figurename}{Fig}

% Make table rows slightly higher
\renewcommand{\arraystretch}{1.2}

% Set footnote size
\renewcommand{\footnotesize}{\fontsize{9pt}{11pt}\selectfont}

% Set itemize margins
\RequirePackage{enumitem}
\setlist[itemize]{leftmargin=13.8mm, labelsep=6.3mm}

% ------------------------------------------------------------------------------
% FONTS, GRAPHICS AND COLOURS
% ------------------------------------------------------------------------------
\RequirePackage{graphicx}% Ability to insert graphics
\RequirePackage{fontspec}% Specify system fonts

% Set main font to Tahoma. Note: Tahoma does not have a real italic shape, so substitute with Arial.
\setmainfont[ItalicFont={Arial Italic},BoldItalicFont={Arial Bold Italic}]{Tahoma}

% Define colours
\RequirePackage[table]{xcolor}%
\definecolor{hisstblue}{RGB}{0,75,160}
\definecolor{footgrey}{RGB}{100,100,100}

% ------------------------------------------------------------------------------
% HEADER AND FOOTER
% ------------------------------------------------------------------------------
\RequirePackage{array}% Columns with fixed width
\newcolumntype{L}[1]{>{\raggedright\let\newline\\\arraybackslash\hspace{0pt}}m{#1}}

\RequirePackage{lastpage}% Get total number of pages
\RequirePackage{fancyhdr}% Headers and footers

\fancypagestyle{plain}{%
	\renewcommand{\headrulewidth}{0pt}%
	\fancyhf{}%
	\lhead{%
		\begin{tabular}[t]{L{2.3cm}L{8.5cm}}
		\includegraphics[width=2cm]{figures/logo_hisst.png}% HiSST Logo
		&
		{\fontsize{12pt}{15pt}\color{hisstblue}\bfseries%
		HiSST: International Conference on High-Speed Vehicle Science Technology
		}\newline\vspace{12pt}%
		{\fontsize{12pt}{15pt}\color{hisstblue}%
		26–29 November 2018, Moscow, Russia
		}
		\end{tabular}%
	}
	\rhead{%
		\raisebox{-20pt}{\includegraphics[width=2cm]{figures/logo_ceas.png}}% CEAS Logo
	}
	\lfoot{\fontsize{8pt}{10pt}\selectfont\color{footgrey} \@manuscriptid\\ \@shorttitle}
	\rfoot{\fontsize{8pt}{10pt}\selectfont\color{footgrey} Page | \thepage\\Copyright © 2018 by the author(s)}
}


\fancyhf{}% Clear style
\renewcommand{\headrulewidth}{0pt}% Remove header line
\renewcommand{\footrulewidth}{0pt}% Remove footer line

\chead{%
\fontsize{10pt}{12pt}\color{hisstblue}%
HiSST: International Conference on High-Speed Vehicle Science Technology\\
\hrulefill\\%
}

\fancyfoot[LO]{\fontsize{8pt}{10pt}\selectfont\color{footgrey} \@manuscriptid\\ \@shorttitle}
\fancyfoot[LE]{\fontsize{8pt}{10pt}\selectfont\color{footgrey} \@manuscriptid\\ \@shortauthor}
\rfoot{\fontsize{8pt}{10pt}\selectfont\color{footgrey} Page | \thepage\\Copyright © 2018 by the author(s)}

\pagestyle{fancy}% Use these headers/footers everywhere

% ------------------------------------------------------------------------------
% FRONTMATTER AND TITLE PAGE
% ------------------------------------------------------------------------------

% Arabic thanks
\makeatletter
\let\@fnsymbol\@arabic

% Thanks formatting as Italic and slightly larger than normal footnotes.
\def\thanks#1{\footnotemark                                                                    
	\protected@xdef\@thanks{\@thanks                                                           
		\protect\footnotetext[\the\c@footnote]{\fontsize{10pt}{12pt}\itshape\selectfont #1}}%                                           
}                                                                                              
\let\@thanks\@empty
\makeatother

% Title
\makeatletter
\def\@maketitle{%
	\newpage
	\null
	\vskip 12pt%
	\begin{center}%
		\let \footnote \thanks
		{\fontsize{12pt}{15pt}\selectfont\bfseries \@title \par}%
		\vskip 12pt%
		{
			\begin{tabular}[t]{c}%
				\itshape \@author
			\end{tabular}\par}%
	\end{center}%
	\par
	\vskip 12pt}
\makeatother

% Abstract
\renewenvironment{abstract}{%
	\begin{minipage}{\textwidth}%
	{\fontsize{11pt}{13pt}\selectfont\bfseries Abstract}\\[10pt]}%
	{%
	\end{minipage}\\[10pt]
}%

% Keywords
\newcommand{\keywords}[1]{{\bfseries Keywords:}\, {\itshape #1}}

% Nomenclature environment
\RequirePackage{multicol}
\newenvironment{nomenclature}
{%
\section*{Nomenclature}
\begin{multicols}{2}%
}
{ 
\end{multicols}%
}

\renewcommand{\descriptionlabel}[1]{#1 \,--\,}
\newenvironment{latin}
{%
	{\itshape Latin}%
	\begin{description}[topsep=-0.5\baselineskip,itemsep=0pt,parsep=0pt,partopsep=0pt]%
	}
	{
	\end{description}%
}

\newenvironment{greek}
{%
	{\itshape Greek}%
	\begin{description}[topsep=-0.5\baselineskip,itemsep=0pt,parsep=0pt,partopsep=0pt]%
	}
	{ 
	\end{description}%
}
\newenvironment{superscripts}
{%
	{\itshape Superscripts}%
	\begin{description}[topsep=-0.5\baselineskip,itemsep=0pt,parsep=0pt,partopsep=0pt]%
	}
	{ 
	\end{description}%
}
\newenvironment{subscripts}
{%
	{\itshape Subscripts}%
	\begin{description}[topsep=-0.5\baselineskip,itemsep=0pt,parsep=0pt,partopsep=0pt]%
	}
	{ 
	\end{description}%
}
% ------------------------------------------------------------------------------